(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     10119,        228]
NotebookOptionsPosition[      9604,        211]
NotebookOutlinePosition[      9942,        226]
CellTagsIndexPosition[      9899,        223]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"files", "=", 
    RowBox[{"FileNames", "[", "\"\<pars*\>\"", "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Generate", " ", "population", " ", "average", " ", "of", " ", "angular", 
     " ", "velocity"}], ",", " ", 
    RowBox[{
    "angular", " ", "velocity", " ", "variance", " ", "and", " ", "perimeter",
      " ", "variance"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"finalresult", "=", 
   RowBox[{"First", "@", 
    RowBox[{"Last", "@", 
     RowBox[{"Reap", "@", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"tardirs", "=", 
          RowBox[{"FileNames", "@", 
           RowBox[{"(", 
            RowBox[{"file", "<>", "\"\</rng*\>\""}], ")"}]}]}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"result", "=", "\[IndentingNewLine]", 
          RowBox[{"Mean", "@", 
           RowBox[{"First", "@", 
            RowBox[{"Last", "@", 
             RowBox[{"Reap", "@", 
              RowBox[{"Do", "[", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                 RowBox[{"Sow", "@", 
                  RowBox[{"Flatten", "@", 
                   RowBox[{"First", "@", 
                    RowBox[{"Last", "@", 
                    RowBox[{"Reap", "[", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"config", "=", 
                    RowBox[{"Import", "[", 
                    RowBox[{"tardir", "<>", "\"\</config.json\>\""}], "]"}]}],
                     ";", "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{"\"\<NUM_CELLS\>\"", "/.", 
                    RowBox[{"(", 
                    RowBox[{"\"\<POPULATION\>\"", "/.", "config"}], ")"}]}], 
                    "]"}], "]"}], ";", "\[IndentingNewLine]", 
                    "\[IndentingNewLine]", 
                    RowBox[{"tmp", "=", 
                    RowBox[{"Import", "[", 
                    RowBox[{
                    RowBox[{"tardir", "<>", "\"\</Analysis.h5\>\""}], ",", 
                    "\"\</Averages/Perimeter\>\""}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{"\"\<Mean\>\"", "/.", "tmp"}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\"\<Variance\>\"", "+", 
                    RowBox[{"\"\<Mean\>\"", "^", "2"}]}], ")"}], "/.", 
                    "tmp"}], "]"}], ";", "\[IndentingNewLine]", 
                    RowBox[{"tmp", "=", 
                    RowBox[{"Import", "[", 
                    RowBox[{
                    RowBox[{"tardir", "<>", "\"\</Analysis.h5\>\""}], ",", 
                    "\"\</Averages/AngularVelocity_CoM\>\""}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{"\"\<Mean\>\"", "/.", "tmp"}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\"\<Variance\>\"", "+", 
                    RowBox[{"\"\<Mean\>\"", "^", "2"}]}], ")"}], "/.", 
                    "tmp"}], "]"}], ";"}], "\[IndentingNewLine]", 
                    "]"}]}]}]}]}], ";"}], "\[IndentingNewLine]", ",", 
                RowBox[{"{", 
                 RowBox[{"tardir", ",", "tardirs"}], "}"}]}], "]"}]}]}]}]}]}],
          ";", "\[IndentingNewLine]", 
         RowBox[{"Sow", "@", "result"}], ";"}], "\[IndentingNewLine]", ",", 
        RowBox[{"{", 
         RowBox[{"file", ",", "files"}], "}"}]}], "]"}]}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"finalresult", "[", 
   RowBox[{"[", 
    RowBox[{";;", ",", "3"}], "]"}], "]"}], "-=", 
  RowBox[{
   RowBox[{"finalresult", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "2"}], "]"}], "]"}], "^", 
   "2"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"finalresult", "[", 
   RowBox[{"[", 
    RowBox[{";;", ",", "5"}], "]"}], "]"}], "-=", 
  RowBox[{
   RowBox[{"finalresult", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "4"}], "]"}], "]"}], "^", "2"}]}]}], "Input",
 CellChangeTimes->{{3.740473733603188*^9, 3.7404737427275352`*^9}, {
   3.7404743487962112`*^9, 3.7404744048960133`*^9}, {3.740474553138999*^9, 
   3.740474576977846*^9}, {3.7404746317376842`*^9, 3.7404747301614637`*^9}, 
   3.7404747631252127`*^9, {3.740474799734309*^9, 3.74047480082445*^9}, {
   3.740475644270343*^9, 3.7404756860640287`*^9}, {3.740475807551002*^9, 
   3.7404759497260637`*^9}, {3.7404782973335257`*^9, 3.740478417250231*^9}, {
   3.7404784807142057`*^9, 3.7404784812280416`*^9}, {3.740562039096106*^9, 
   3.740562116814569*^9}, {3.740562223374802*^9, 3.740562234714262*^9}, {
   3.740562362929048*^9, 3.7405623843951073`*^9}, {3.740562420435128*^9, 
   3.740562658752768*^9}, 3.740563059159471*^9, {3.740563165138597*^9, 
   3.740563168861841*^9}, {3.740563243686219*^9, 3.740563246699719*^9}, {
   3.7405635603605328`*^9, 3.7405636014813633`*^9}, {3.740572893734722*^9, 
   3.74057289796838*^9}, 3.740573734870708*^9, {3.7406397600526047`*^9, 
   3.740639779423215*^9}, {3.740639996821848*^9, 3.740640057971066*^9}, {
   3.740640103630518*^9, 3.7406401046933813`*^9}, {3.740640148469658*^9, 
   3.74064016450458*^9}, {3.7406402223577623`*^9, 3.740640229789052*^9}, {
   3.740640468942174*^9, 3.740640491188933*^9}, 3.7407191473255672`*^9, {
   3.740719183834629*^9, 3.740719184076961*^9}, {3.7407194346455793`*^9, 
   3.7407194535781307`*^9}, {3.740725792331171*^9, 3.7407257958827457`*^9}, {
   3.740725829635138*^9, 3.740725857059944*^9}, {3.740726097172914*^9, 
   3.7407261001087503`*^9}, {3.74072711031215*^9, 3.740727117945513*^9}, {
   3.740727471560315*^9, 3.740727482062001*^9}, {3.7407312439849977`*^9, 
   3.74073125063311*^9}, {3.740731286377161*^9, 3.7407314900148573`*^9}, {
   3.740731742662314*^9, 3.740731747838747*^9}, {3.7407318166911917`*^9, 
   3.7407318175868473`*^9}, {3.740731889782754*^9, 3.7407318966421432`*^9}, {
   3.7407321268142967`*^9, 3.7407321328602667`*^9}, {3.740732258343833*^9, 
   3.7407322689325943`*^9}, {3.74073235640373*^9, 3.740732387789772*^9}, {
   3.740732444405113*^9, 3.7407324458294277`*^9}, {3.740736365662232*^9, 
   3.74073638087253*^9}, {3.740918436092173*^9, 3.740918436274705*^9}, 
   3.740918546605487*^9, {3.740918595432824*^9, 3.740918654134107*^9}, {
   3.740918715753393*^9, 3.740918732746752*^9}, {3.74107805544772*^9, 
   3.741078110742749*^9}, {3.741951907695805*^9, 3.741951924525962*^9}, {
   3.7419670716196747`*^9, 3.7419670791092997`*^9}, {3.7420563768205023`*^9, 
   3.742056397773793*^9}, {3.742665501182191*^9, 3.7426655167970343`*^9}, {
   3.74736414505101*^9, 3.747364145335045*^9}, {3.7473667542430763`*^9, 
   3.74736680210285*^9}, {3.747368654669873*^9, 3.747368654902927*^9}, {
   3.7765357785808277`*^9, 
   3.77653586951972*^9}},ExpressionUUID->"4a0e8568-03be-46e1-bbc4-\
f4aa69d21521"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"#1", " ", "cell", " ", "count"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#2", " ", "perimeter", " ", "mean"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#3", " ", "perimeter", " ", "variance"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#4", " ", "angular", " ", "velocity", " ", "mean"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#5", " ", "angular", " ", "velocity", " ", "variance"}], " ", 
   "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Export", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Export", "[", 
   RowBox[{"\"\<~/Downloads/thueroffpaper_rot_N1.dat\>\"", ",", 
    RowBox[{
     RowBox[{"SortBy", "[", 
      RowBox[{"res", ",", "First"}], "]"}], "/.", 
     RowBox[{"Indeterminate", "\[Rule]", "0."}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.742747835884862*^9, 3.742747887231217*^9}, 
   3.746361436572936*^9, {3.747368678480659*^9, 3.747368691394476*^9}, 
   3.7473687263229523`*^9, {3.75373085748416*^9, 3.753730857837769*^9}, {
   3.776535931353994*^9, 
   3.776535955098575*^9}},ExpressionUUID->"5fb36f54-ab59-4a13-9c40-\
fc68bed66a08"],

Cell[BoxData["\<\"~/Downloads/thueroffpaper_rot_N1.dat\"\>"], "Output",
 CellChangeTimes->{3.742747836505327*^9, 3.7427478876066732`*^9, 
  3.746361438988803*^9, 3.7473687290561333`*^9, 3.75373089252774*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"1128ba00-64bb-46cd-a472-b48259afa83b"]
}, Open  ]]
},
WindowSize->{808, 755},
WindowMargins->{{Automatic, 270}, {Automatic, 13}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 7402, 149, 577, "Input",ExpressionUUID->"4a0e8568-03be-46e1-bbc4-f4aa69d21521"],
Cell[CellGroupData[{
Cell[7985, 173, 1314, 30, 178, "Input",ExpressionUUID->"5fb36f54-ab59-4a13-9c40-fc68bed66a08"],
Cell[9302, 205, 286, 3, 34, "Output",ExpressionUUID->"1128ba00-64bb-46cd-a472-b48259afa83b"]
}, Open  ]]
}
]
*)

